package gov.va.med.domain.service.messaging.parse;

import gov.va.med.domain.model.IPayload;
import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.MessagingException;
import gov.va.med.domain.service.messaging.decode.MessageDecoder;
import gov.va.med.domain.service.messaging.environment.NamingDirectory;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import ca.uhn.hl7v2.HL7Exception;

/**
 * HL7MessageMetadata Data Transfer Object with HL7 message preparse data.
 * 
 * @author Slava Uchitel
 * @version $Id: HL7MessageMetadata.java,v 1.1.2.20 2005/05/09 19:57:27
 *          slava.uchitel Exp $
 * @since MHV 2.0 <br>
 *        03/15/2005
 */

public class HL7MessageMetadata //extends AbstractVO 
		implements Serializable, IPayload
		{
	private static final long serialVersionUID = 3258407344143872305L;

	public static final String SEND_APPLICATION_ACK_FUNCTION = "sendApplicationAcknowledgement";
	private static final Map UNSOLICITED_FUNCTIONS = createUnsolicitedFunctions();

	private String messageType;

	private String triggerEvent;

	private String messageStructure;

	private String messageControlId;

	/**
	 * For incoming messages, this is the DestinationKey as used for
	 * Desitinations
	 */
	private String sendingSystemId;

	private String sendingSystemDomain;

	private String receivingSystemId;

	private String receivingSystemDomain;

	private String sendingApplication;

	private String receivingApplication;

	private String systemType;

	private String commitAckInd;

	private String applicationAckInd;

	private String ackCode;

	private String ackError;

	private String ackText;

	private String correlationMessageControlId;

	private String category;

	private String icn;

	private String ssn;

	private String dfn;

	private String requestId;

	private String extractDate;

	private String queryAcknowledgementCode;

	private Integer recordsInThisMessage;

	private Integer recordsTotalNumber;

	private String masterFileId;

	//This variable holds original message.
	//It is used for special case MFN-M05 application ack.
	//In all other cases it is set to null.
	private String message;

	/**
	 * @return Returns the message.
	 */
	public String getMessage()
	{
		return message;
	}

	/**
	 * @param message
	 *            The message to set.
	 */
	public void setMessage(String message)
	{
		this.message = message;
	}

	private long messageSize;

	public String getMessageType()
	{
		return messageType;
	}

	public static String lookupUnsolicitedFunction(String key)
	{
		return (String) UNSOLICITED_FUNCTIONS.get(key);
	}

	private static Map createUnsolicitedFunctions()
	{
		Map functions = new HashMap(11);
		functions.put("MFN^M05^MFN_M05(TFL)^200M", "updatePatientFacilities");
		functions.put("ADT^A04^ADT_A04^200M", "updatePatientInformation");
		functions.put("ADT^A04^ADT_A01^200M", "updatePatientInformation");
		functions.put("ADT^A08^ADT_A08^200M", "updatePatientInformation");
		functions.put("ADT^A08^ADT_A01^200M", "updatePatientInformation");
		functions.put("ADT^A24^ADT_A24^200M", "mergePatient");
		functions.put("ADT^A43^ADT_A43^200M", "movePatient");
		functions.put("MFN^Z01^MFN_Z01", "updateSiteInformation");
		functions.put("MFN^Z01^MFN_M01", "updateSiteInformation");
		functions.put("ACK^A24^ACK_A24^200M", "linkPatient");
		functions.put("ACK^A37^ACK_A37^200M", "unlinkPatient");

		return functions;
		//FUTURE In future, we could get unsolicited PHR extracts for corrections
		//to history. These will need to be accounted for here and also
		//with Handlers, Decoders and Functions.
	}

	public String getTriggerEvent()
	{
		return triggerEvent;
	}

	public String getMessageStructure()
	{
		if (messageStructure != null && messageStructure.trim().length() > 0)
		{

			return messageStructure;
		}
		if (getMessageType() != null && getMessageType().trim().length() > 0
				&& getTriggerEvent() != null
				&& getTriggerEvent().trim().length() > 0)
		{

			return (getMessageType().trim() + "_" + getTriggerEvent().trim());
		}

		return messageStructure;
	}

	/**
	 * Determines function name from message type <p/><p/>
	 * 
	 */
	private String mapToFunction()
	{
		// fabricate from message type and file to derive
		// nice function nmae.
		// For example MFN M05 file type TFL ==> updateTreatmentFacilities
		// Also, check source to ensure they come from trusted source i.e MPI.
		String key = getMessageType() + "^" + getTriggerEvent() + "^"
				+ getMessageStructure();
		if (key.equals("MFN^M05^MFN_M05"))
			key = key + "(" + getMasterFileId() + ")";
		else if (getRequestId() == null || getRequestId().trim().length() == 0)
		{
			if (getCategory() != null && getCategory().trim().length() > 0)
			{
				key = key + "(" + getCategory().trim() + ")";
			}
		}

		if (UNSOLICITED_FUNCTIONS.containsKey(key + "^" + getSendingSystemId()))
		{
			return (String) UNSOLICITED_FUNCTIONS.get(key + "^"
					+ getSendingSystemId());
		}
		if (UNSOLICITED_FUNCTIONS.containsKey(key))
		{
			return (String) UNSOLICITED_FUNCTIONS.get(key);
		}
		return null;
	}

	/**
	 * Derives a function name from message metadata
	 * <P>
	 * Format is messageType + "^" + triggerEvent + "^" + messageStructure + "^" +
	 * category (if it exists)
	 * 
	 * @return name or null if no valid function or invalid source
	 */
	public String getFunctionName()
	{
		return mapToFunction();
	}

	public boolean isApplicationAckRequired()
	{
		return (MessagingConstants.ALWAYS_ACKNOWLEDGE.equals(getApplicationAckInd()));
	}

	public String getMessageContolId()
	{
		return messageControlId;
	}

	public String getSendingSystemId()
	{
		return sendingSystemId;
	}

	public String getReceivingSystemId()
	{
		return receivingSystemId;
	}

	public String getSendingApplication()
	{
		return sendingApplication;
	}

	public String getReceivingApplication()
	{
		return receivingApplication;
	}

	public String getSystemType()
	{
		return systemType;
	}

	public String getCommitAckInd()
	{
		return commitAckInd;
	}

	public String getApplicationAckInd()
	{
		return applicationAckInd;
	}

	public String getAckCode()
	{
		return ackCode;
	}

	public String getAckError()
	{
		return ackError;
	}

	public String getAckText()
	{
		return ackText;
	}

	public String getCategory()
	{
		return category;
	}

	public String getIcn()
	{
		return icn;
	}

	public String getRequestId()
	{
		return requestId;
	}

	public String getQueryAcknowledgementCode()
	{
		return queryAcknowledgementCode;
	}

	public Integer getRecordsInThisMessage()
	{
		return recordsInThisMessage;
	}

	public Integer getRecordsTotalNumber()
	{
		return recordsTotalNumber;
	}

	public String getExtractDate()
	{
		return extractDate;
	}

	public Date getParsedExtractDate() throws MessagingException
	{
		return MessageDecoder.stringToDate(getExtractDate());
	}

	public boolean hasRequestId()
	{
		String reqId = getRequestId();
		return reqId != null && reqId.trim().length() > 0;
	}

	public boolean isOk()
	{
		return (getAckCode() == null || getAckCode().equals("AA"));
	}

	public void setMessageType(String value)
	{
		messageType = value;
	}

	public void setTriggerEvent(String value)
	{
		triggerEvent = value;
	}

	public void setMessageStructure(String value)
	{
		messageStructure = value;
	}

	public void setMessageContolId(String value)
	{
		messageControlId = value;
	}

	public void setSendingSystemId(String value)
	{
		sendingSystemId = value;
	}

	public void setReceivingSystemId(String value)
	{
		receivingSystemId = value;
	}

	public void setSendingApplication(String value)
	{
		sendingApplication = value;
	}

	public void setReceivingApplication(String value)
	{
		receivingApplication = value;
	}

	public void setSystemType(String value)
	{
		systemType = value;
	}

	public void setCommitAckInd(String value)
	{
		commitAckInd = value;
	}

	public void setApplicationAckInd(String value)
	{
		applicationAckInd = value;
	}

	public void setAckCode(String value)
	{
		ackCode = value;
	}

	public void setAckError(String value)
	{
		ackError = value;
	}

	public void setAckText(String value)
	{
		ackText = value;
	}

	public void setCategory(String value)
	{
		category = value;
	}

	public void setIcn(String value)
	{
		icn = value;
	}

	public void setRequestId(String value)
	{
		requestId = value;
	}

	public void setQueryAcknowledgementCode(String value)
	{
		queryAcknowledgementCode = value;
	}

	public void setRecordsInThisMessage(Integer value)
	{
		recordsInThisMessage = value;
	}

	public void setRecordsTotalNumber(Integer value)
	{
		recordsTotalNumber = value;
	}

	public void setExtractDate(String value)
	{
		extractDate = value;
	}

	public void setSendingSystemDomain(String value)
	{
		sendingSystemDomain = value;
	}

	public long getLongRequestId()
	{
		return Long.parseLong(getRequestId());
	}

	public String getSendingSystemDomain()
	{
		return sendingSystemDomain;
	}

	public void setReceivingSystemDomain(String value)
	{
		receivingSystemDomain = value;
	}

	public String getReceivingSystemDomain()
	{
		return receivingSystemDomain;
	}

	public void setMessageSize(long value)
	{
		messageSize = value;
	}

	public long getMessageSize()
	{
		return messageSize;
	}

	public String getDfn()
	{
		return dfn;
	}

	public void setDfn(String value)
	{
		dfn = value;
	}

	public String getMessageControlId()
	{
		return messageControlId;
	}

	public void setMessageControlId(String messageControlId)
	{
		this.messageControlId = messageControlId;
	}

	public void setMasterFileId(String masterFileId)
	{
		this.masterFileId = masterFileId;
	}

	public String getMasterFileId()
	{
		return masterFileId;
	}

	/**
	 * @return Returns the correlationMessageControlId.
	 */
	 public String getCorrelationMessageControlId()
	{
		return correlationMessageControlId;
	}

	/**
	 * @param correlationMessageControlId
	 *            The correlationMessageControlId to set.
	 */
	 public void setCorrelationMessageControlId(
			 String correlationMessageControlId)
	{
		this.correlationMessageControlId = correlationMessageControlId;
	}

	/**
	 * @return Returns the ssn.
	 */
	 public String getSsn()
	 {
		 return ssn;
	 }

	 /**
	  * @param ssn
	  *            The ssn to set.
	  */
	 public void setSsn(String ssn)
	 {
		 this.ssn = ssn;
	 }

	 private String getCanonicIcn(String icn)
	 {
		 if (icn==null)
			 return null;
		 int i = icn.indexOf("V");
		 return (i<0?icn:icn.substring(0,i));
	 }

	 public boolean isIcnEqual(String icnToCompare)
	 {
		 if (icnToCompare==null || getIcn()==null)
			 return false;
		 return (getCanonicIcn(getIcn())).equalsIgnoreCase(getCanonicIcn(icnToCompare));
	 }
}
